import { DeviceInfo, DeviceHealthMetrics, DeviceStatus } from './device.types';
import { PlaylistItem } from './playlist.types';
export declare enum ServerToClientEvent {
    CONTENT_UPDATE = "content:update",
    DISPLAY_NAVIGATE = "display:navigate",
    SCREENSHOT_REQUEST = "screenshot:request",
    CONFIG_UPDATE = "config:update",
    DEVICE_RESTART = "device:restart",
    DISPLAY_REFRESH = "display:refresh"
}
export declare enum ServerToAdminEvent {
    DEVICE_CONNECTED = "admin:device:connected",
    DEVICE_DISCONNECTED = "admin:device:disconnected",
    DEVICE_STATUS_CHANGED = "admin:device:status",
    DEVICE_HEALTH_UPDATE = "admin:device:health",
    SCREENSHOT_RECEIVED = "admin:screenshot:received",
    ERROR_OCCURRED = "admin:error"
}
export declare enum ClientToServerEvent {
    DEVICE_REGISTER = "device:register",
    SCREENSHOT_UPLOAD = "screenshot:upload",
    HEALTH_REPORT = "health:report",
    DEVICE_STATUS = "device:status",
    ERROR_REPORT = "error:report"
}
export interface ContentUpdatePayload {
    playlistId: number;
    items: PlaylistItem[];
}
export interface DisplayNavigatePayload {
    url: string;
    duration?: number;
}
export interface ScreenshotRequestPayload {
    timestamp: number;
}
export interface ConfigUpdatePayload {
    screenshotInterval?: number;
    healthCheckInterval?: number;
    [key: string]: any;
}
export interface DeviceRestartPayload {
    message?: string;
}
export interface DisplayRefreshPayload {
    force?: boolean;
}
export interface DeviceRegisterPayload {
    deviceInfo: DeviceInfo;
}
export interface ScreenshotUploadPayload {
    image: string;
    timestamp: number;
    currentUrl: string;
}
export interface HealthReportPayload extends DeviceHealthMetrics {
}
export interface DeviceStatusPayload {
    status: DeviceStatus;
    message?: string;
}
export interface ErrorReportPayload {
    error: string;
    stack?: string;
    context?: any;
}
export interface AdminDeviceConnectedPayload {
    deviceId: string;
    timestamp: Date;
}
export interface AdminDeviceDisconnectedPayload {
    deviceId: string;
    timestamp: Date;
}
export interface AdminDeviceStatusPayload {
    deviceId: string;
    status: DeviceStatus;
    timestamp: Date;
}
export interface AdminDeviceHealthPayload {
    deviceId: string;
    health: DeviceHealthMetrics;
    timestamp: Date;
}
export interface AdminScreenshotReceivedPayload {
    deviceId: string;
    screenshotId: number;
    timestamp: Date;
}
export interface AdminErrorPayload {
    deviceId: string;
    error: string;
    timestamp: Date;
}
export interface WebSocketAuthPayload {
    token?: string;
    role?: 'device' | 'admin';
}
