export interface User {
    id: number;
    username: string;
    email?: string;
    createdAt: Date;
    updatedAt: Date;
}
export interface LoginDto {
    username: string;
    password: string;
}
export interface RegisterDto {
    username: string;
    password: string;
    email?: string;
}
export interface AuthResponse {
    accessToken: string;
    refreshToken: string;
    user: User;
}
export interface RefreshTokenDto {
    refreshToken: string;
}
export interface JwtPayload {
    sub: number;
    username: string;
    iat?: number;
    exp?: number;
}
