"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientToServerEvent = exports.ServerToAdminEvent = exports.ServerToClientEvent = void 0;
// WebSocket Events - Backend to Client (Devices)
var ServerToClientEvent;
(function (ServerToClientEvent) {
    ServerToClientEvent["CONTENT_UPDATE"] = "content:update";
    ServerToClientEvent["DISPLAY_NAVIGATE"] = "display:navigate";
    ServerToClientEvent["SCREENSHOT_REQUEST"] = "screenshot:request";
    ServerToClientEvent["CONFIG_UPDATE"] = "config:update";
    ServerToClientEvent["DEVICE_RESTART"] = "device:restart";
    ServerToClientEvent["DISPLAY_REFRESH"] = "display:refresh";
    ServerToClientEvent["REMOTE_CLICK"] = "remote:click";
    ServerToClientEvent["REMOTE_TYPE"] = "remote:type";
    ServerToClientEvent["REMOTE_KEY"] = "remote:key";
    ServerToClientEvent["REMOTE_SCROLL"] = "remote:scroll";
    ServerToClientEvent["PLAYLIST_PAUSE"] = "playlist:pause";
    ServerToClientEvent["PLAYLIST_RESUME"] = "playlist:resume";
    ServerToClientEvent["PLAYLIST_NEXT"] = "playlist:next";
    ServerToClientEvent["PLAYLIST_PREVIOUS"] = "playlist:previous";
    ServerToClientEvent["PLAYLIST_BROADCAST_START"] = "playlist:broadcast:start";
    ServerToClientEvent["PLAYLIST_BROADCAST_END"] = "playlist:broadcast:end";
})(ServerToClientEvent || (exports.ServerToClientEvent = ServerToClientEvent = {}));
// WebSocket Events - Backend to Admin UI
var ServerToAdminEvent;
(function (ServerToAdminEvent) {
    ServerToAdminEvent["DEVICE_CONNECTED"] = "admin:device:connected";
    ServerToAdminEvent["DEVICE_DISCONNECTED"] = "admin:device:disconnected";
    ServerToAdminEvent["DEVICE_STATUS_CHANGED"] = "admin:device:status";
    ServerToAdminEvent["DEVICE_HEALTH_UPDATE"] = "admin:device:health";
    ServerToAdminEvent["SCREENSHOT_RECEIVED"] = "admin:screenshot:received";
    ServerToAdminEvent["ERROR_OCCURRED"] = "admin:error";
    ServerToAdminEvent["PLAYBACK_STATE_CHANGED"] = "admin:playback:state";
})(ServerToAdminEvent || (exports.ServerToAdminEvent = ServerToAdminEvent = {}));
// WebSocket Events - Client to Backend
var ClientToServerEvent;
(function (ClientToServerEvent) {
    ClientToServerEvent["DEVICE_REGISTER"] = "device:register";
    ClientToServerEvent["SCREENSHOT_UPLOAD"] = "screenshot:upload";
    ClientToServerEvent["HEALTH_REPORT"] = "health:report";
    ClientToServerEvent["DEVICE_STATUS"] = "device:status";
    ClientToServerEvent["ERROR_REPORT"] = "error:report";
    ClientToServerEvent["PLAYBACK_STATE_UPDATE"] = "playback:state:update";
})(ClientToServerEvent || (exports.ClientToServerEvent = ClientToServerEvent = {}));
