import { DeviceInfo, DeviceHealthMetrics, DeviceStatus } from './device.types';
import { PlaylistItem } from './playlist.types';
export declare enum ServerToClientEvent {
    CONTENT_UPDATE = "content:update",
    DISPLAY_NAVIGATE = "display:navigate",
    SCREENSHOT_REQUEST = "screenshot:request",
    CONFIG_UPDATE = "config:update",
    DEVICE_RESTART = "device:restart",
    DISPLAY_REFRESH = "display:refresh",
    REMOTE_CLICK = "remote:click",
    REMOTE_TYPE = "remote:type",
    REMOTE_KEY = "remote:key",
    REMOTE_SCROLL = "remote:scroll",
    PLAYLIST_PAUSE = "playlist:pause",
    PLAYLIST_RESUME = "playlist:resume",
    PLAYLIST_NEXT = "playlist:next",
    PLAYLIST_PREVIOUS = "playlist:previous",
    PLAYLIST_BROADCAST_START = "playlist:broadcast:start",
    PLAYLIST_BROADCAST_END = "playlist:broadcast:end"
}
export declare enum ServerToAdminEvent {
    DEVICE_CONNECTED = "admin:device:connected",
    DEVICE_DISCONNECTED = "admin:device:disconnected",
    DEVICE_STATUS_CHANGED = "admin:device:status",
    DEVICE_HEALTH_UPDATE = "admin:device:health",
    SCREENSHOT_RECEIVED = "admin:screenshot:received",
    ERROR_OCCURRED = "admin:error",
    PLAYBACK_STATE_CHANGED = "admin:playback:state"
}
export declare enum ClientToServerEvent {
    DEVICE_REGISTER = "device:register",
    SCREENSHOT_UPLOAD = "screenshot:upload",
    HEALTH_REPORT = "health:report",
    DEVICE_STATUS = "device:status",
    ERROR_REPORT = "error:report",
    PLAYBACK_STATE_UPDATE = "playback:state:update"
}
export interface ContentUpdatePayload {
    playlistId: number;
    items: PlaylistItem[];
}
export interface DisplayNavigatePayload {
    url: string;
    duration?: number;
}
export interface ScreenshotRequestPayload {
    timestamp: number;
}
export interface ConfigUpdatePayload {
    screenshotInterval?: number;
    healthCheckInterval?: number;
    displayWidth?: number;
    displayHeight?: number;
    kioskMode?: boolean;
    [key: string]: any;
}
export interface DeviceRestartPayload {
    message?: string;
}
export interface DisplayRefreshPayload {
    force?: boolean;
}
export interface RemoteClickPayload {
    x: number;
    y: number;
    button?: 'left' | 'right' | 'middle';
}
export interface RemoteTypePayload {
    text: string;
    selector?: string;
}
export interface RemoteKeyPayload {
    key: string;
    modifiers?: ('Shift' | 'Control' | 'Alt' | 'Meta')[];
}
export interface RemoteScrollPayload {
    x?: number;
    y?: number;
    deltaX?: number;
    deltaY?: number;
}
export interface DeviceRegisterPayload {
    deviceInfo: DeviceInfo;
}
export interface ScreenshotUploadPayload {
    image: string;
    timestamp: number;
    currentUrl: string;
}
export interface HealthReportPayload extends DeviceHealthMetrics {
}
export interface DeviceStatusPayload {
    status: DeviceStatus;
    message?: string;
}
export interface ErrorReportPayload {
    error: string;
    stack?: string;
    context?: any;
}
export interface AdminDeviceConnectedPayload {
    deviceId: string;
    timestamp: Date;
}
export interface AdminDeviceDisconnectedPayload {
    deviceId: string;
    timestamp: Date;
}
export interface AdminDeviceStatusPayload {
    deviceId: string;
    status: DeviceStatus;
    timestamp: Date;
}
export interface AdminDeviceHealthPayload {
    deviceId: string;
    health: DeviceHealthMetrics;
    timestamp: Date;
}
export interface AdminScreenshotReceivedPayload {
    deviceId: string;
    screenshotId: number;
    timestamp: Date;
}
export interface AdminErrorPayload {
    deviceId: string;
    error: string;
    timestamp: Date;
}
export interface PlaylistPausePayload {
}
export interface PlaylistResumePayload {
}
export interface PlaylistNextPayload {
    respectConstraints?: boolean;
}
export interface PlaylistPreviousPayload {
    respectConstraints?: boolean;
}
export interface PlaylistBroadcastStartPayload {
    type: 'url' | 'message' | 'image' | 'video';
    url?: string;
    message?: string;
    duration?: number;
    background?: string;
    logo?: string;
    logoPosition?: string;
    mediaData?: string;
}
export interface PlaylistBroadcastEndPayload {
}
export interface PlaybackStateUpdatePayload {
    isPlaying: boolean;
    isPaused: boolean;
    isBroadcasting: boolean;
    currentItemId: number | null;
    currentItemIndex: number;
    playlistId: number | null;
    totalItems: number;
    currentUrl: string | null;
    timeRemaining: number | null;
}
export interface AdminPlaybackStatePayload {
    deviceId: string;
    state: PlaybackStateUpdatePayload;
    timestamp: Date;
}
export interface WebSocketAuthPayload {
    token?: string;
    role?: 'device' | 'admin';
}
