import type { ContentUpdatePayload, DisplayNavigatePayload, ScreenshotRequestPayload, ConfigUpdatePayload, DeviceRestartPayload, DisplayRefreshPayload, DeviceStatus, RemoteClickPayload, RemoteTypePayload, RemoteKeyPayload, RemoteScrollPayload, PlaylistPausePayload, PlaylistResumePayload, PlaylistNextPayload, PlaylistPreviousPayload, PlaylistBroadcastStartPayload, PlaylistBroadcastEndPayload, PlaybackStateUpdatePayload } from '@jimmyeao/shared';
export declare const DeviceStatusValues: {
    readonly ONLINE: DeviceStatus;
    readonly OFFLINE: DeviceStatus;
    readonly ERROR: DeviceStatus;
};
export type ContentUpdateCallback = (payload: ContentUpdatePayload) => void;
export type DisplayNavigateCallback = (payload: DisplayNavigatePayload) => void;
export type ScreenshotRequestCallback = (payload: ScreenshotRequestPayload) => void;
export type ConfigUpdateCallback = (payload: ConfigUpdatePayload) => void;
export type DeviceRestartCallback = (payload: DeviceRestartPayload) => void;
export type DisplayRefreshCallback = (payload: DisplayRefreshPayload) => void;
export type RemoteClickCallback = (payload: RemoteClickPayload) => void;
export type RemoteTypeCallback = (payload: RemoteTypePayload) => void;
export type RemoteKeyCallback = (payload: RemoteKeyPayload) => void;
export type RemoteScrollCallback = (payload: RemoteScrollPayload) => void;
export type StreamStartCallback = (payload: any) => void;
export type StreamStopCallback = (payload: any) => void;
export type ScreencastStartCallback = () => void;
export type ScreencastStopCallback = () => void;
export type PlaylistPauseCallback = (payload: PlaylistPausePayload) => void;
export type PlaylistResumeCallback = (payload: PlaylistResumePayload) => void;
export type PlaylistNextCallback = (payload: PlaylistNextPayload) => void;
export type PlaylistPreviousCallback = (payload: PlaylistPreviousPayload) => void;
export type PlaylistBroadcastStartCallback = (payload: PlaylistBroadcastStartPayload) => void;
export type PlaylistBroadcastEndCallback = (payload: PlaylistBroadcastEndPayload) => void;
declare class WebSocketClient {
    private socket;
    private reconnectAttempts;
    private maxReconnectAttempts;
    private isConnected;
    private contentUpdateCallback?;
    private displayNavigateCallback?;
    private screenshotRequestCallback?;
    private configUpdateCallback?;
    private deviceRestartCallback?;
    private displayRefreshCallback?;
    private remoteClickCallback?;
    private remoteTypeCallback?;
    private remoteKeyCallback?;
    private remoteScrollCallback?;
    private streamStartCallback?;
    private streamStopCallback?;
    private screencastStartCallback?;
    private screencastStopCallback?;
    private playlistPauseCallback?;
    private playlistResumeCallback?;
    private playlistNextCallback?;
    private playlistPreviousCallback?;
    private playlistBroadcastStartCallback?;
    private playlistBroadcastEndCallback?;
    constructor();
    connect(): void;
    private setupEventHandlers;
    private registerDevice;
    disconnect(): void;
    getConnectionStatus(): boolean;
    sendHealthReport(health: any): void;
    sendDeviceStatus(status: DeviceStatus, message?: string): void;
    sendErrorReport(error: string, stack?: string, context?: any): void;
    sendScreenshot(image: string, currentUrl: string): void;
    sendScreencastFrame(frameData: {
        data: string;
        metadata: any;
    }): void;
    sendPlaybackState(state: PlaybackStateUpdatePayload): void;
    private send;
    onContentUpdate(callback: ContentUpdateCallback): void;
    onDisplayNavigate(callback: DisplayNavigateCallback): void;
    onScreenshotRequest(callback: ScreenshotRequestCallback): void;
    onConfigUpdate(callback: ConfigUpdateCallback): void;
    onDeviceRestart(callback: DeviceRestartCallback): void;
    onDisplayRefresh(callback: DisplayRefreshCallback): void;
    onRemoteClick(callback: RemoteClickCallback): void;
    onRemoteType(callback: RemoteTypeCallback): void;
    onRemoteKey(callback: RemoteKeyCallback): void;
    onRemoteScroll(callback: RemoteScrollCallback): void;
    onStreamStart(callback: StreamStartCallback): void;
    onStreamStop(callback: StreamStopCallback): void;
    onScreencastStart(callback: ScreencastStartCallback): void;
    onScreencastStop(callback: ScreencastStopCallback): void;
    onPlaylistPause(callback: PlaylistPauseCallback): void;
    onPlaylistResume(callback: PlaylistResumeCallback): void;
    onPlaylistNext(callback: PlaylistNextCallback): void;
    onPlaylistPrevious(callback: PlaylistPreviousCallback): void;
    onPlaylistBroadcastStart(callback: PlaylistBroadcastStartCallback): void;
    onPlaylistBroadcastEnd(callback: PlaylistBroadcastEndCallback): void;
}
export declare const websocketClient: WebSocketClient;
export {};
//# sourceMappingURL=websocket.d.ts.map