"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDevices = getDevices;
exports.createDevice = createDevice;
exports.getPlaylists = getPlaylists;
exports.createPlaylist = createPlaylist;
exports.getPlaylistItems = getPlaylistItems;
exports.createPlaylistItem = createPlaylistItem;
exports.getContent = getContent;
exports.createContent = createContent;
exports.getLatestScreenshot = getLatestScreenshot;
const config_1 = require("../config");
async function request(method, path, body) {
    const url = new URL(path, config_1.config.serverUrl);
    const res = await fetch(url.toString(), {
        method,
        headers: {
            'Content-Type': 'application/json',
        },
        body: body !== undefined ? JSON.stringify(body) : undefined,
    });
    if (!res.ok) {
        const text = await res.text();
        throw new Error(`HTTP ${res.status} ${res.statusText}: ${text}`);
    }
    return (await res.json());
}
// Devices
async function getDevices() {
    return await request('GET', '/devices');
}
async function createDevice(dto) {
    return await request('POST', '/devices', dto);
}
// Playlists
async function getPlaylists() {
    return await request('GET', '/playlists');
}
async function createPlaylist(dto) {
    return await request('POST', '/playlists', dto);
}
async function getPlaylistItems(playlistId) {
    return await request('GET', `/playlists/${playlistId}/items`);
}
async function createPlaylistItem(dto) {
    return await request('POST', '/playlists/items', dto);
}
// Content
async function getContent() {
    return await request('GET', '/content');
}
async function createContent(dto) {
    return await request('POST', '/content', dto);
}
// Screenshots
async function getLatestScreenshot(deviceId) {
    return await request('GET', `/screenshots/device/${deviceId}/latest`);
}
//# sourceMappingURL=api.js.map