import type { PlaylistItem, PlaybackStateUpdatePayload } from '@jimmyeao/shared';
declare class PlaylistExecutor {
    private playlistItems;
    private currentIndex;
    private timeoutId;
    private isRunning;
    private defaultRotationMs;
    private isPaused;
    private pausedAt;
    private remainingDuration;
    private currentItemStartTime;
    private savedPlaylist;
    private savedIndex;
    private isBroadcasting;
    private currentPlaylistId;
    private stateEmissionIntervalId;
    loadPlaylist(items: PlaylistItem[], playlistId?: number): Promise<void>;
    start(): void;
    stop(): void;
    pause(): void;
    resume(): void;
    next(respectConstraints?: boolean): void;
    previous(respectConstraints?: boolean): void;
    private getLogoPositionStyles;
    private generateMediaPage;
    startBroadcast(type: 'url' | 'message' | 'image' | 'video', url?: string, message?: string, duration?: number, background?: string, logo?: string, logoPosition?: string, mediaData?: string): void;
    endBroadcast(): void;
    getPlaybackState(): PlaybackStateUpdatePayload;
    private emitStateUpdate;
    private isItemValid;
    private executeNextItem;
    private getNextValidItem;
    private getPreviousValidItem;
    private formatTime;
    private hasSchedulingChanged;
    private displayContent;
    getCurrentItem(): PlaylistItem | null;
    getPlaylistItems(): PlaylistItem[];
    hasPlaylist(): boolean;
    refreshState(): void;
}
export declare const playlistExecutor: PlaylistExecutor;
export {};
//# sourceMappingURL=playlist-executor.d.ts.map