export declare enum CacheStatus {
    NotCached = "not_cached",
    Downloading = "downloading",
    Ready = "ready",
    Error = "error"
}
export declare class ContentCacheManager {
    private cacheDir;
    private activeDownloads;
    private cacheEntries;
    constructor();
    private ensureCacheDir;
    getLocalPath(url: string): string | null;
    getCacheStatus(url: string): CacheStatus;
    waitForCache(url: string, maxWaitMs?: number): Promise<string | null>;
    syncPlaylist(items: any[]): Promise<void>;
    private syncPlaylistInternal;
    private cleanup;
    isCacheable(url: string): boolean;
    private getRelativePathFromUrl;
    private downloadVideoWrapper;
    private fetchText;
    private downloadFile;
}
export declare const contentCacheManager: ContentCacheManager;
//# sourceMappingURL=content-cache.d.ts.map