"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = exports.configManager = void 0;
const dotenv = __importStar(require("dotenv"));
const path = __importStar(require("path"));
// Load environment variables from working directory (not relative to __dirname which changes after compilation)
// This allows the .env file to be in /opt/theiacast-client/ when running as a service
dotenv.config({ path: path.join(process.cwd(), '.env') });
class ConfigManager {
    constructor() {
        this.config = this.loadConfig();
        this.validateConfig();
    }
    loadConfig() {
        return {
            serverUrl: process.env.SERVER_URL || 'http://localhost:5000',
            deviceToken: process.env.DEVICE_TOKEN || '',
            displayWidth: parseInt(process.env.DISPLAY_WIDTH || '1920', 10),
            displayHeight: parseInt(process.env.DISPLAY_HEIGHT || '1080', 10),
            kioskMode: process.env.KIOSK_MODE === 'true',
            puppeteerExecutablePath: process.env.PUPPETEER_EXECUTABLE_PATH || undefined,
            healthCheckInterval: parseInt(process.env.HEALTH_CHECK_INTERVAL || '60000', 10),
            // Default to 30s to match UI expectations and backend sampling
            // Enforce a minimum cadence to prevent excessive screenshots
            screenshotInterval: Math.max(parseInt(process.env.SCREENSHOT_INTERVAL || '30000', 10), 30000),
            logLevel: (process.env.LOG_LEVEL || 'info'),
        };
    }
    validateConfig() {
        const errors = [];
        if (!this.config.deviceToken) {
            errors.push('DEVICE_TOKEN is required');
        }
        if (!this.config.serverUrl) {
            errors.push('SERVER_URL is required');
        }
        if (errors.length > 0) {
            throw new Error(`Configuration validation failed:\n${errors.join('\n')}`);
        }
    }
    get() {
        return { ...this.config };
    }
    update(updates) {
        this.config = { ...this.config, ...updates };
    }
}
exports.configManager = new ConfigManager();
exports.config = exports.configManager.get();
//# sourceMappingURL=config.js.map